<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Ultimate Media Gallery v1.4.3                                          # ||
|| #                                                                        # ||
|| # ---------------------------------------------------------------------- # ||
|| # Copyright  2008-2009 pHp-unlimited. All Rights Reserved.              # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| # It's not allowed to delete this Information.                           # ||
|| ########################################################################## ||
\*============================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting (E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define ('THIS_SCRIPT', 'umg');
define ('CSRF_PROTECTION', true);

// ######################### REQUIRE BACK-END ############################
require_once ('./global.php');
require_once (DIR . '/umg_gallery/umg_functions.php');

$vbulletin->input->clean_array_gpc ('r', array (
	'do'      => TYPE_STR,
	'w'       => TYPE_INT,
	'r'       => TYPE_INT,
	'mediaid' => TYPE_INT,
));

$show_media = 1;
$media = $db->query_first ("SELECT 
	m.*,c.userid AS gallery 
	FROM " . TABLE_PREFIX . "umg_media AS m 
	LEFT JOIN " . TABLE_PREFIX . "umg_category AS c ON (c.catid=m.catid) 
	WHERE mediaid=" . $vbulletin->GPC['mediaid']
);

$ofname = strtolower ($media['filename']);

if (!$media['mediaid'])
{
}
else
{
	if ($media['active'])
	{
		if ($vbulletin->userinfo['userid'])
		{
			if (($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canhavepublic']))
			{
				if ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['umgadmin']) $umg_group = 3;
				else if ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['umgsmod']) $umg_group = 2;
				else if ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['umgmod']) $umg_group = 1;

				if ($umg_group)
				{
					$umg_permissions = $db->query_first ("SELECT * FROM " . TABLE_PREFIX . "umg_usergroup WHERE umgid=" . $umg_group);
					$vbulletin->userinfo = array_merge ($vbulletin->userinfo, $umg_permissions);
				}
			}
		}

		if (($vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid'] == $media['userid']) OR ($vbulletin->userinfo['userid'] AND $vbulletin->userinfo['deletemedia']))
		{
		}
		else exit();
	}

	if ($vbulletin->GPC['do'] == 's') $vbulletin->GPC['do'] = 'small';
	else if ($vbulletin->GPC['do'] == 'm') $vbulletin->GPC['do'] = 'medium';
	else if ($vbulletin->GPC['do'] == 'o') $vbulletin->GPC['do'] = 'original';
	else $vbulletin->GPC['do'] = 'small';

	$extension = $media['filetype'];
	$filename = DIR . '/umg_gallery/images/' . $media['category'] . '/' . $vbulletin->GPC['do'] . '/' . $media['mediaid'] . '_' . $media['filename'];
	$image_data = file_get_contents ($filename);

	if ($extension == 'gif')
	{
		$image = @imagecreatefromgif ($filename);
	}
	else if ($extension == 'jpg' OR $extension == 'jpeg')
	{
		$image = @imagecreatefromjpeg ($filename);
	}
	else if ($extension == 'png')
	{
		$image = @imagecreatefrompng ($filename);
	}
	$osizes = @getimagesize ($filename);

	// we want to resize our image
	$percent = $vbulletin->GPC['r'];
	if ($percent)
	{
		$new_w = round ($osizes[0]  - (($osizes[0] / 100) * $percent), 0);
		$new_h = round ($osizes[1]  - (($osizes[1] / 100) * $percent), 0);

		$new_image = @imagecreatetruecolor ($new_w, $new_h);

		@imagecopyresampled ($new_image, $image, 0, 0, 0, 0, $new_w, $new_h, $osizes[0], $osizes[1]);
		$osizes[0] = $new_w;
		$osizes[1] = $new_h;
		$image = $new_image;
		unset ($new_image);
	}

	// create a watermark
	if (!$media['gallery'] AND $vbulletin->GPC['w'] AND $vbulletin->options['umgtn_watermark'] AND in_array ($extension, array ('jpg', 'jpeg', 'gif', 'png')))
	{
		$watermark_file = DIR . '/' . $vbulletin->options['umgtn_logopath'];
		$wextension = array_pop (explode ('.', $watermark_file));

		$wsizes = @getimagesize ($watermark_file);

		$image_w = $osizes[0];																	// original width
		$image_h = $osizes[1];																	// original height

		if ($wextension == 'gif')
		{
			$watermark = @imagecreatefromgif ($watermark_file);
		}
		else if ($wextension == 'jpg' OR $wextension == 'jpeg')
		{
			$watermark = @imagecreatefromjpeg ($watermark_file);
		}
		else if ($wextension == 'png')
		{
			$watermark = @imagecreatefrompng ($watermark_file);
		}
		if ($watermark)
		{
			$watermark_w = @imagesx ($watermark);									// watermark width
			$watermark_h = @imagesy ($watermark);									// watermark height
		}

		if ($percent AND $watermark)
		{
			// we resized our image, so let's resize our watermark
			// we want to resize our image
			$new_w = round ($watermark_w  - (($watermark_w / 100) * $percent), 0);
			$new_h = round ($watermark_h  - (($watermark_h / 100) * $percent), 0);

			$new_image = @imagecreatetruecolor ($new_w, $new_h);

			if ($wextension == 'gif' OR $wextension == 'png') @imagealphablending ($new_image, true);

			$rgb_color = umg_get_rgb ();
			$transparecy_color = @imagecolorallocate ($new_image, $rgb_color[0], $rgb_color[1], $rgb_color[2]);

			@imagefill ($new_image, 0, 0, $transparecy_color);
			@imagecolortransparent ($new_image, $transparecy_color);
			@imagealphablending ($new_image, true);

			@imagecopyresampled ($new_image, $watermark, 0, 0, 0, 0, $new_w, $new_h, $watermark_w, $watermark_h);

			$watermark_w = $new_w;
			$watermark_h = $new_h;
			$watermark = $new_image;
			unset ($new_image);
		}

		if ($watermark_w >= $image_w) $watermark = '';

		$set_watermark = $vbulletin->options['umgtn_logopo'];
		switch ($set_watermark)
		{
			case 1:																								// upper left
				$logo_x = 0;
				$logo_y = 0;
				break;
			case 2:																								// upper middle
				$logo_x = round (($image_w / 2), 0) - round (($watermark_w / 2), 0);
				$logo_y = 0;
				break;
			case 3:																								// upper right
				$logo_x = $image_w - $watermark_w;
				$logo_y = 0;
				break;

			case 4:																								// middle left
				$logo_x = 0;
				$logo_y = round (($image_h / 2), 0) - round (($watermark_h / 2), 0);
				break;
			case 5:																								// middle right
				$logo_x = $image_w - $watermark_w;
				$logo_y = round (($image_h / 2), 0) - round (($watermark_h / 2), 0);
				break;

			case 6:																								// lower left
				$logo_x = 0;
				$logo_y = $image_h - $watermark_h;
				break;
			case 7:																								// lower middle
				$logo_x = round (($image_w / 2), 0) - round (($watermark_w / 2), 0);
				$logo_y = $image_h - $watermark_h;
				break;
			case 8:																								// lower right
				$logo_x = $image_w - $watermark_w;
				$logo_y = $image_h - $watermark_h;
				break;

			default:
				$logo_x = 0;
				$logo_y = 0;
				break;
		}
		if ($watermark AND ($extension == 'gif' OR $extension == 'png'))
		{
			@imagealphablending ($watermark, true);
			$new_image = @imagecreatetruecolor ($image_w, $image_h);
			$rgb_color = umg_get_rgb ();
			$transparecy_color = @imagecolorallocate ($new_image, $rgb_color[0], $rgb_color[1], $rgb_color[2]);

			@imagefill ($new_image, 0, 0, $transparecy_color);
			@imagecolortransparent ($new_image, $transparecy_color);
			@imagealphablending ($new_image, true);

			@imagecopy ($new_image, $image, 0, 0, 0, 0, $image_w, $image_h);
			@imagecopy ($new_image, $watermark, $logo_x, $logo_y, 0, 0, $watermark_w, $watermark_h);
		}
		else if ($watermark AND ($extension == 'jpg' OR $extension == 'jpeg'))
		{
			$new_image = @imagecreatetruecolor ($image_w, $image_h);

			$rgb_color = umg_get_rgb ();
			$transparecy_color = @imagecolorallocate ($new_image, $rgb_color[0], $rgb_color[1], $rgb_color[2]);

			@imagefill ($new_image, 0, 0, $transparecy_color);
			@imagecolortransparent ($new_image, $transparecy_color);
			@imagealphablending ($new_image, true);

			@imagecopy ($new_image, $image, 0, 0, 0, 0, $image_w, $image_h);
			@imagecopy ($new_image, $watermark, $logo_x, $logo_y, 0, 0, $watermark_w, $watermark_h);
		}
		if ($watermark)
		{
			header ('Cache-control: no-cache, must-revalidate');
			header ('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
			header ('Content-disposition: inline; filename=' . $ofname);
			header ('Last-Modified:  Sat, 26 Jul 1997 05:00:00 GMT');
			header ('ETag: "' . $media['mediaid'] . '"');
			header ('Accept-Ranges: bytes');
			header ('Content-type: image/jpeg');
			@imagejpeg ($new_image, '', 100);
			exit();
		}
	}

	if ($percent)
	{
		header ('Cache-control: no-cache, must-revalidate');
		header ('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
		header ('Content-disposition: inline; filename=' . $ofname);
		header ('Last-Modified:  Sat, 26 Jul 1997 05:00:00 GMT');
		header ('ETag: "' . $media['mediaid'] . '"');
		header ('Accept-Ranges: bytes');
		header ('Content-type: image/jpeg');
		@imagejpeg ($image, '', 100);
		exit();
	}

	if (in_array ($extension, array ('bmp', 'tif', 'tiff', 'gif', 'psd', 'pdf')))
	{
		$filename = preg_replace ('#.(bmp|tiff?|psd|pdf)$#i', '.jpg', $filename);
		$mimetype = array ('Content-type: image/jpeg');
	}
	else
	{
		$mimetype = array ('Content-type: unknown/unknown');
	}

	header ('Cache-control: max-age=31536000, private');
	header ('Expires: ' . gmdate ("D, d M Y H:i:s", TIMENOW + 31536000) . ' GMT');
	header ('Content-disposition: inline; filename=' . $ofname);
	header ('Last-Modified: ' . gmdate ('D, d M Y H:i:s', $media['dateline']) . ' GMT');
	header ('ETag: "' . $media['mediaid'] . '"');
	header ('Accept-Ranges: bytes');

	if (preg_match ('~&#([0-9]+);~', $filename))
	{
		if (function_exists ('iconv'))
		{
			$filename_conv = @iconv ($stylevar['charset'], 'UTF-8//IGNORE', $filename);
			if ($filename_conv !== false)
			{
				$filename = $filename_conv;
			}
		}

		$filename = preg_replace ('~&#([0-9]+);~e', "convert_int_to_utf8('\\1')", $filename);
		$filename_charset = 'utf-8';
	}
	else
	{
		$filename_charset = $stylevar['charset'];
	}

	$filename = preg_replace ('#[\r\n]#', '', $filename);

	if (is_browser ('mozilla'))
	{
		$filename = "filename*=" . $filename_charset . "''" . rawurlencode ($filename);
	}
	else
	{
		if ($filename_charset != 'utf-8' AND function_exists ('iconv'))
		{
			$filename_conv = iconv ($filename_charset, 'UTF-8//IGNORE', $filename);
			if ($filename_conv !== false)
			{
				$filename = $filename_conv;
			}
		}

		if (is_browser ('opera') OR is_browser ('konqueror') OR is_browser ('safari'))
		{
			$filename = 'filename="' . str_replace ('"', '', $filename) . '"';
		}
		else
		{
			$filename = 'filename="' . rawurlencode ($filename) . '"';
		}
	}

	if (in_array ($extension, array ('jpg', 'jpe', 'jpeg', 'gif', 'png')))
	{
//		header ("Content-disposition: inline; $filename");
		header ('Content-disposition: inline; filename=' . $ofname);
		header ('Content-transfer-encoding: binary');
	}
	else
	{
//		header ("Content-disposition: attachment; $filename");
		header ('Content-disposition: inline; filename=' . $ofname);
	}

	if (is_array ($mimetype))
	{
		foreach ($mimetype AS $header)
		{
			if (!empty ($header))
			{
				header ($header);
			}
		}
	}
	else
	{
		header ('Content-type: unknown/unknown');
	}

	echo $image_data;
}
exit ();
?>
